CREATE OR REPLACE FUNCTION code.delete_contacts_tag(
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_tag_id bigint,
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    tag_name text;
    tag_type contacts.tag_type;
BEGIN
    SELECT name, type
      FROM contacts.tags
     WHERE user_id = i_user_id AND user_type = i_user_type AND tag_id = i_tag_id
      INTO tag_name, tag_type;

    IF NOT FOUND THEN
        RETURN revision - 1;
    END IF;

    IF EXISTS (
        SELECT 1
          FROM code.default_contacts_tags()
         WHERE name = tag_name AND type = tag_type
    ) THEN
        RAISE EXCEPTION 'Delete default tag is forbidden'
              USING HINT = 'Delete only not default tags';
    END IF;

    DELETE FROM contacts.tags
     WHERE user_id = i_user_id AND user_type = i_user_type AND tag_id = i_tag_id;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'delete_tag'::contacts.change_type,
        i_arguments := jsonb_build_object('tag_id', i_tag_id),
        i_changed := jsonb_build_object('name', tag_name, 'type', tag_type),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
