CREATE OR REPLACE FUNCTION code.delete_contacts_user(
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_x_request_id text,
    i_check_user_is_here boolean default false
) RETURNS void AS $$
DECLARE
    revision bigint;
BEGIN
    IF i_check_user_is_here AND NOT impl.check_contacts_user_is_here(i_user_id, i_user_type) THEN
        RAISE WARNING 'code.delete_contacts_user: user (%, %) is not here', i_user_id, i_user_type;
        RETURN;
    END IF;

    revision := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );

    UPDATE contacts.users
       SET is_deleted = true
     WHERE user_id = i_user_id AND user_type = i_user_type;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'delete_user'::contacts.change_type,
        i_arguments := jsonb_build_object(),
        i_changed := jsonb_build_object(),
        i_x_request_id := i_x_request_id
    );
END
$$ LANGUAGE plpgsql;
