CREATE OR REPLACE FUNCTION code.purge_contacts_user (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_force boolean default false,
    i_full  boolean default true
) RETURNS void AS $$
BEGIN
    IF NOT i_force AND EXISTS (
        SELECT 1
          FROM contacts.users
         WHERE user_id = i_user_id AND user_type = i_user_type AND is_here AND NOT is_deleted
    ) THEN
        RAISE EXCEPTION 'User is not deleted, user_id: %, user_type: %', i_user_id, i_user_type
              USING HINT = 'Delete or transfer user first before purge';
    END IF;

    DELETE FROM contacts.equivalent_revisions
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.shared_lists
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.subscribed_lists
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.emails_tags
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.contacts_tags
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.emails
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.directory_entities
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.contacts
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.tags
     WHERE user_id = i_user_id AND user_type = i_user_type;

    DELETE FROM contacts.lists
     WHERE user_id = i_user_id AND user_type = i_user_type;

    IF i_full THEN
        DELETE FROM contacts.change_log
         WHERE user_id = i_user_id AND user_type = i_user_type;

        DELETE FROM contacts.users
         WHERE user_id = i_user_id AND user_type = i_user_type;
    END IF;
END
$$ LANGUAGE plpgsql;
