CREATE OR REPLACE FUNCTION code.reinit_deleted_contacts_user(
    i_user_id bigint,
    i_user_type contacts.user_type
) RETURNS void AS $$
DECLARE
    v_is_here boolean;
    v_is_deleted boolean;
BEGIN
    SELECT is_here, is_deleted
      FROM contacts.users
     WHERE user_id = i_user_id AND user_type = i_user_type
      INTO v_is_here, v_is_deleted;

    IF FOUND THEN
        IF v_is_here AND v_is_deleted THEN
            UPDATE contacts.users
               SET is_deleted = false
             WHERE user_id = i_user_id AND user_type = i_user_type;
        END IF;
    END IF;
END;
$$ LANGUAGE plpgsql;
