CREATE OR REPLACE FUNCTION code.revoke_contacts_list (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_list_id bigint,
    i_client_user_id bigint,
    i_client_user_type contacts.user_type,
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
BEGIN
    DELETE FROM contacts.shared_lists
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND list_id = i_list_id
       AND client_user_id = i_client_user_id
       AND client_user_type = i_client_user_type;

    IF NOT FOUND THEN
        RETURN revision - 1;
    END IF;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'revoke_list'::contacts.change_type,
        i_arguments := jsonb_build_object(
            'list_id', i_list_id,
            'client_user_id', i_client_user_id,
            'client_user_type', i_client_user_type
        ),
        i_changed := jsonb_build_object(),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
