CREATE OR REPLACE FUNCTION code.subscribe_to_contacts_list (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_list_id bigint,
    i_owner_user_id bigint,
    i_owner_user_type contacts.user_type,
    i_owner_list_id bigint,
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    inserted bigint;
BEGIN
    INSERT INTO contacts.subscribed_lists
        (user_id, user_type, list_id, owner_user_id, owner_user_type, owner_list_id, revision)
    VALUES (i_user_id, i_user_type, i_list_id, i_owner_user_id, i_owner_user_type, i_owner_list_id, revision)
    ON CONFLICT DO NOTHING;

    GET DIAGNOSTICS inserted = ROW_COUNT;

    IF inserted = 0 THEN
        RETURN revision - 1;
    END IF;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'subscribe_to_list'::contacts.change_type,
        i_arguments := jsonb_build_object(
            'list_id', i_list_id,
            'owner_user_id', i_owner_user_id,
            'owner_user_type', i_owner_user_type,
            'owner_list_id', i_owner_list_id
        ),
        i_changed := jsonb_build_object(),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
