CREATE OR REPLACE FUNCTION code.tag_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_tag_id bigint,
    i_contact_ids bigint[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    contact_id bigint;
    inserted_contact_ids bigint[];
BEGIN
    WITH i AS (
        INSERT INTO contacts.contacts_tags (user_id, user_type, contact_id, tag_id, revision)
        SELECT i_user_id, i_user_type, v, i_tag_id, revision
          FROM unnest(i_contact_ids) v
        ON CONFLICT DO NOTHING
        RETURNING contacts.contacts_tags.contact_id AS contact_id
    )
    SELECT array_agg(i.contact_id)
      FROM i
      INTO inserted_contact_ids;

    IF inserted_contact_ids IS NULL THEN
        RETURN revision - 1;
    END IF;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'tag_contacts'::contacts.change_type,
        i_arguments := jsonb_build_object('tag_id', i_tag_id, 'contact_ids', i_contact_ids),
        i_changed := jsonb_build_object('contact_ids', inserted_contact_ids),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
