CREATE OR REPLACE FUNCTION code.tag_contacts_emails (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_tag_id bigint,
    i_email_ids bigint[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    new_revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    email_id bigint;
    tagged_emails impl.tagged_email[];
BEGIN
    WITH i AS (
        INSERT INTO contacts.emails_tags (user_id, user_type, contact_id, email_id, tag_id, revision)
        SELECT i_user_id, i_user_type, t.contact_id, v, i_tag_id, new_revision
          FROM unnest(i_email_ids) v
          JOIN contacts.emails t ON (t.email_id = v AND t.user_id = i_user_id AND t.user_type = i_user_type)
        ON CONFLICT DO NOTHING
        RETURNING contacts.emails_tags.contact_id AS contact_id, contacts.emails_tags.email_id AS email_id
    )
    SELECT array_agg((i.email_id, i.contact_id)::impl.tagged_email)
      FROM i
      INTO tagged_emails;

    IF tagged_emails IS NULL THEN
        RETURN new_revision - 1;
    END IF;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := new_revision,
        i_type := 'tag_emails'::contacts.change_type,
        i_arguments := jsonb_build_object('tag_id', i_tag_id, 'email_ids', i_email_ids),
        i_changed := jsonb_build_object('tagged_emails', tagged_emails),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
