CREATE OR REPLACE FUNCTION code.min_xact_contacts(
) RETURNS timestamp with time zone AS $$
    SELECT min(xact_start)
        FROM pg_locks l
        JOIN pg_class c
          ON (l.relation = c.oid)
        JOIN pg_stat_activity sa
          ON (sa.pid = l.pid)
        JOIN pg_namespace ns
          ON (ns.oid = c.relnamespace)
    WHERE c.relname ~ 'change_log'
        AND l.mode = 'RowExclusiveLock'
        AND ns.nspname = 'contacts'
        AND datname = current_database()
$$ LANGUAGE SQL SECURITY DEFINER;


