CREATE OR REPLACE FUNCTION code.blacklist_add(
    i_uid filters.elist.uid%type,
    i_list filters.elist.list%type,
    i_email filters.elist.email%type
) RETURNS integer AS $$
DECLARE
    res integer;
BEGIN
    INSERT INTO filters.elist (uid, list, email)
    SELECT i_uid, i_list, i_email
     WHERE (SELECT count(*)
              FROM filters.elist
             WHERE uid = i_uid
               AND list = i_list) < impl.get_blacklist_limit();
    GET DIAGNOSTICS res = ROW_COUNT;
    RETURN res;
END;
$$ language 'plpgsql';
