CREATE OR REPLACE FUNCTION code.blacklist_remove(
    i_uid filters.elist.uid%type,
    i_list filters.elist.list%type,
    i_email text[]
) RETURNS integer AS $$
DECLARE
    res integer;
BEGIN
    DELETE FROM filters.elist
     WHERE uid = i_uid
       AND list = i_list
       AND email = ANY(i_email);
    GET DIAGNOSTICS res = ROW_COUNT;
    RETURN res;
END;
$$ language 'plpgsql';
