CREATE OR REPLACE FUNCTION code.create_rule(
    i_uid filters.rules.uid%type,
    i_name filters.rules.name%type,
    i_enabled BOOLEAN,
    i_stop BOOLEAN,
    i_last BOOLEAN,
    i_acts TEXT[],
    i_conds TEXT[],
    i_old_id filters.rules.rule_id%type = NULL,
    inout i_new_id filters.rules.rule_id%type = NULL,
    i_type filters.rules.type%type = 'user'
) AS $$
DECLARE
    new_actions impl.action_def[];
    new_conditions impl.condition_def[];
BEGIN
    new_actions := impl.make_actions(i_uid, i_acts);
    new_conditions := impl.make_conditions(i_conds);

    i_new_id := impl.new_rule(i_new_id, i_uid, i_name, i_enabled, i_stop, i_last, i_type, i_old_id);

    -- insert rule actions
    INSERT INTO filters.actions (
      uid, rule_id, oper, param, verified
    ) SELECT
        i_uid, i_new_id, ad_oper, ad_param, ad_verified
      FROM
        UNNEST(new_actions);

    -- insert rule conditions
    INSERT INTO filters.conditions (
      uid, rule_id, field_type, field, pattern, oper, link, negative
    ) SELECT
        i_uid, i_new_id, cd_field_type, cd_field, cd_pattern, cd_oper, cd_link, cd_negative
      FROM
        UNNEST(new_conditions);
END;
$$ language 'plpgsql';
