CREATE OR REPLACE FUNCTION code.create_unsubscribe(
    i_uid    filters.rules.uid%type,
    i_params TEXT[]
) RETURNS TABLE (
    id BIGINT
) AS $$
DECLARE
    p_div constant SMALLINT := 4;
    v_email TEXT;
    v_message_type TEXT;
    v_fid TEXT;
    v_rule_name filters.rules.name%type;
    v_rule_type constant filters.rules.type%type := 'unsubscribe';
BEGIN
    IF array_length(i_params, 1) % p_div != 0 THEN
      RAISE EXCEPTION 'Parameters length is not a factor of %', p_div;
    END IF;

    PERFORM code.acquire_current_revision(i_uid);

    FOR i IN 1 .. array_length(i_params, 1) / p_div LOOP
      v_email := CAST(i_params[i * p_div - 3] AS TEXT);
      v_rule_name := CAST(i_params[i * p_div - 2] AS TEXT);
      v_message_type := CAST(i_params[i * p_div - 1] AS TEXT);
      v_fid := CAST(i_params[i * p_div] AS TEXT);

      -- finding existing rule --
      id := impl.get_unsubscribe_filter(i_uid, v_email, v_message_type);

      IF id IS NULL THEN
        id := impl.new_rule(
          i_new_id => NULL,
          i_uid => i_uid,
          i_name => v_rule_name,
          i_enabled => TRUE,
          i_stop => FALSE,
          i_last => TRUE,
          i_type => v_rule_type
        );

        INSERT INTO filters.actions (
          uid, rule_id, oper, param
        ) VALUES (
          i_uid, id, 'move', v_fid
        );

        INSERT INTO filters.conditions (
          uid, rule_id, field_type, field, pattern, oper, link
        ) VALUES
        ( i_uid, id, 'header', 'from', v_email, 'matches', 'and' ),
        ( i_uid, id, 'type', NULL, v_message_type, 'matches', 'and' );
      END IF;

      RETURN NEXT;
    END LOOP;
END;
$$ language 'plpgsql';
