CREATE OR REPLACE FUNCTION code.order_rules_with_check(
    i_uid filters.rules.uid%type,
    i_ids BIGINT[]
) RETURNS BOOLEAN AS $$
DECLARE
    p filters.rules.prio%type := 0;
    i filters.rules.rule_id%type;
    v_current BIGINT[] := NULL;
    v_requested BIGINT[] := NULL;
BEGIN
    v_current := ARRAY(
      SELECT rule_id
      FROM filters.rules
      WHERE uid = i_uid
      AND type = 'user'
      ORDER BY rule_id
    );
    v_requested := ARRAY(
      SELECT id
      FROM unnest(i_ids) AS id
      ORDER BY id
    );

    -- The set of incoming rule's ids (i_ids) should be equivalent to the
    -- current user's rule ids from the filters.rules table.
    -- Duplicates are prohibited, incomplete set of ids is prohibited too.

    IF v_current = v_requested THEN
      FOREACH i IN array i_ids LOOP
          p := p + 1;
          UPDATE filters.rules
             SET prio = p
           WHERE uid = i_uid
             AND rule_id = i;
      END LOOP;
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END IF;
END;
$$ language 'plpgsql';
