CREATE OR REPLACE FUNCTION code.verify_action(
  i_uid filters.rules.uid%type,
  i_id filters.actions.action_id%type)
RETURNS VOID AS $$
DECLARE
    i filters.rules.rule_id%type;
BEGIN
    UPDATE filters.actions
       SET verified = TRUE
     WHERE uid = i_uid AND action_id = i_id;

    SELECT rule_id INTO i
      FROM filters.actions
     WHERE uid = i_uid AND action_id = i_id;

    -- enable rule if all its actions are now verified (should be a trigger)
    IF (SELECT count(*) FROM filters.actions
         WHERE rule_id = i AND verified = FALSE) = 0
    THEN
        UPDATE filters.rules
           SET enabled = TRUE
         WHERE uid = i_uid AND rule_id = i;
    END IF;
END;
$$ language 'plpgsql';
