CREATE OR REPLACE FUNCTION code.extract_lids(
    i_labels mail.thread_label[]
) RETURNS integer[] AS $$
    SELECT COALESCE(l, ARRAY[]::integer[])
      FROM (
        SELECT array_agg(l[id].lid) l
          FROM (
            SELECT i_labels l, generate_subscripts(i_labels, 1) id
        ) t) tl;
$$ LANGUAGE SQL IMMUTABLE;