CREATE FUNCTION code.filter_recipients_by_type(
    i_recipients mail.recipient[],
    i_type       mail.recipient_type
) RETURNS mail.recipient[] AS $$
SELECT ARRAY(
    SELECT r
      FROM unnest(i_recipients) AS r
     WHERE r.type = i_type
);
$$ LANGUAGE SQL IMMUTABLE;

-- create operator in public schema,
-- cause don't want modify default search_path

CREATE OPERATOR public.-> (
    LEFTARG = mail.recipient[],
    RIGHTARG = mail.recipient_type,
    PROCEDURE = code.filter_recipients_by_type
);
