CREATE OR REPLACE FUNCTION code.filter_recipients_by_type_and_get_head(
    i_recipients mail.recipient[],
    i_type       mail.recipient_type
) RETURNS mail.recipient AS $$
SELECT r
  FROM unnest(i_recipients) AS r
 WHERE r.type = i_type
 LIMIT 1;
$$ LANGUAGE SQL IMMUTABLE;

-- create operator in public schema,
-- cause don't want modify default search_path

CREATE OPERATOR public.->> (
    LEFTARG = mail.recipient[],
    RIGHTARG = mail.recipient_type,
    PROCEDURE = code.filter_recipients_by_type_and_get_head
);
