CREATE OR REPLACE FUNCTION code.fail_subscription_transitions()
RETURNS TABLE (
    from_state mail.subscription_state,
    to_state   mail.subscription_state
) AS $$
SELECT from_state::mail.subscription_state,
       to_state::mail.subscription_state
  FROM (
    VALUES
        ('init',         'init-fail'),
        ('init-fail',    'init-fail'),
        ('sync',         'sync-fail'),
        ('sync-fail',    'sync-fail'),
        ('migrate',      'migrate-fail'),
        ('migrate-fail', 'migrate-fail'),
        ('clear',        'clear-fail'),
        ('clear-fail',   'clear-fail')
) AS t(from_state, to_state);
$$ LANGUAGE SQL IMMUTABLE;
