
CREATE OR REPLACE FUNCTION code.subscription_transitions()
RETURNS TABLE (
    action     code.subscription_action,
    from_state mail.subscription_state,
    to_state   mail.subscription_state
) AS $$
SELECT action::code.subscription_action,
       from_state::mail.subscription_state,
       to_state::mail.subscription_state
  FROM (
    VALUES
        ('initialization',  'new',              'init'),
        ('initialization',  'init',             'init'),
        ('synchronization', 'init',             'sync'),
        ('synchronization', 'sync',             'sync'),
        ('synchronization', 'migrate',          'sync'),
        ('synchronization', 'migrate-finished', 'sync'),
        ('migration',       'sync',             'migrate'),
        ('migration',       'migrate',          'migrate'),
        ('migration',       'migrate-finished', 'migrate'),
        ('unsubscription',  'new',              'discontinued'),
        ('unsubscription',  'init',             'discontinued'),
        ('unsubscription',  'sync',             'discontinued'),
        ('unsubscription',  'init-fail',        'discontinued'),
        ('unsubscription',  'sync-fail',        'discontinued'),
        ('unsubscription',  'discontinued',     'discontinued'),
        ('clearing',        'discontinued',     'clear'),
        ('clearing',        'clear',            'clear'),
        ('termination',     'migrate',          'migrate-finished'),
        ('termination',     'clear',            'terminated'),
        ('termination',     'terminated',       'terminated')
) AS t(action, from_state, to_state);
$$ LANGUAGE SQL IMMUTABLE;
