CREATE OR REPLACE FUNCTION code.user_state_transitions()
RETURNS TABLE (
    from_state mail.user_state,
    to_state   mail.user_state
) AS $$
SELECT from_state::mail.user_state,
       to_state::mail.user_state
  FROM (
    VALUES
        ('special',     'active'),
        ('special',     'deleted'),
        ('active',      'special'),
        ('active',      'inactive'),
        ('active',      'deleted'),
        ('inactive',    'special'),
        ('inactive',    'active'),
        ('inactive',    'notified'),
        ('inactive',    'deleted'),
        ('notified',    'special'),
        ('notified',    'active'),
        ('notified',    'notified'),
        ('notified',    'frozen'),
        ('notified',    'deleted'),
        ('frozen',      'active'),
        ('frozen',      'archived'),
        ('frozen',      'deleted'),
        ('archived',    'active'),
        ('archived',    'deleted'),
        ('deleted',     'active')
) AS t(from_state, to_state);
$$ LANGUAGE SQL IMMUTABLE;
