CREATE OR REPLACE FUNCTION code.check_chains(i_uid bigint)
    RETURNS SETOF code.check_record AS $$
DECLARE
BEGIN
    RETURN QUERY
        SELECT 'box.chain.first_imap_id'::text AS name,
                row_to_json(x.*, true) AS broken
          FROM (
            SELECT li.*
              FROM mail.folders f,
                   LATERAL(
                    SELECT fid, imap_id, chain
                      FROM mail.box b
                     WHERE b.uid = f.uid
                       AND b.fid = f.fid
                     ORDER BY imap_id LIMIT 1) li
             WHERE f.uid = i_uid
               AND chain IS NULL) x;

    RETURN QUERY
        SELECT 'box.chain'::text AS name,
                row_to_json(x.*, true) AS broken
          FROM (
            SELECT fid, imap_id, chain,
                   row_number() OVER (
                       PARTITION BY fid, block_id ORDER BY imap_id DESC
                   ) AS r_chain
              FROM (
                SELECT fid, imap_id, chain,
                       sum(coalesce(chain, 0)) OVER (
                            PARTITION BY fid ORDER BY imap_id
                       ) AS block_id
                  FROM mail.box cb
                 WHERE cb.uid = i_uid) bc) x
         WHERE chain IS NOT NULL
           AND chain != r_chain;
END;
$$ LANGUAGE plpgsql;