CREATE OR REPLACE FUNCTION code.check_subscribed_folders(i_uid bigint)
    RETURNS SETOF code.check_record AS $$
BEGIN
    RETURN QUERY
        SELECT 'serials.next_subscriber_subscription_id'::text AS name,
                row_to_json(x.*, true) AS broken
          FROM (
            SELECT s.next_subscriber_subscription_id,
                   used.max_subscription_id
              FROM mail.serials s,
                (SELECT max(subscription_id) max_subscription_id
                   FROM mail.subscribed_folders
                  WHERE uid = i_uid) used
             WHERE s.uid = i_uid
               AND s.next_subscriber_subscription_id <= used.max_subscription_id
          ) x;
END;
$$ LANGUAGE plpgsql;
