CREATE OR REPLACE FUNCTION code.find_threads_by_hash(
    i_uid           bigint,
    i_namespace     mail.thread_hash_namespaces,
    i_value         numeric,
    i_uniq_key      bigint,
    i_received_date timestamp,
    i_days_limit    interval,
    i_count_limit   integer
) RETURNS SETOF code.thread_info AS $$
    SELECT t.tid, t.message_count
      FROM mail.threads_hashes th,
           mail.threads t
     WHERE th.uid = i_uid
       AND namespace = i_namespace
       AND value = i_value
       AND uniq_key = i_uniq_key
       AND t.uid = th.uid
       AND t.tid = th.tid
       AND (i_days_limit IS NULL OR t.newest_date > (i_received_date - i_days_limit))
       AND (i_count_limit IS NULL OR t.message_count < i_count_limit)
$$ LANGUAGE sql;
