CREATE OR REPLACE FUNCTION code.find_threads_by_references(
    i_uid            bigint,
    i_message_ids    text[],
    i_references     numeric[]
) RETURNS SETOF code.thread_info AS $$
    SELECT tid, message_count
      FROM mail.threads
     WHERE uid = i_uid
       AND tid in (
        SELECT tid
          FROM mail.box
         WHERE uid = i_uid
           AND mid IN (
            SELECT mh.mid
              FROM mail.messages mh
             WHERE mh.uid = i_uid
               AND mh.hdr_message_id = ANY(i_message_ids)
             UNION
            SELECT mr.mid
              FROM mail.message_references mr
             WHERE mr.uid = i_uid
               AND mr.value = ANY(i_references)
           ));
$$ LANGUAGE sql;
