CREATE OR REPLACE FUNCTION code.get_message_chained(
    i_uid     bigint,
    i_fid     integer,
    i_imap_id bigint
) RETURNS code.chained_message AS $$
    SELECT (chained_id,
           (SELECT COUNT(*) - 1
              FROM mail.box md
             WHERE md.uid = i_uid
               AND md.fid = i_fid
               AND md.imap_id
                BETWEEN chained_id
                    AND i_imap_id))::code.chained_message
      FROM (
        SELECT MAX(imap_id) AS chained_id
          FROM mail.box
         WHERE uid = i_uid AND fid = i_fid
           AND chain IS NOT NULL
           AND imap_id < i_imap_id) mc;
$$ LANGUAGE sql STABLE;
