CREATE OR REPLACE FUNCTION code.labels_by_lids(
    i_uid  code.uid,
    i_lids integer[]
) RETURNS code.label_key[] AS $$
SELECT ARRAY(
    SELECT (name, type)::code.label_key
      FROM mail.labels
     WHERE uid = i_uid
       AND lid = ANY(i_lids)
);
$$ LANGUAGE SQL STABLE RETURNS NULL ON NULL INPUT;

CREATE OR REPLACE FUNCTION public.labels(
    mail.box
) RETURNS code.label_key[] AS $$
SELECT code.labels_by_lids($1.uid, $1.lids);
$$ LANGUAGE SQL STABLE RETURNS NULL ON NULL INPUT;