CREATE OR REPLACE FUNCTION code.create_label(
    i_uid     code.uid,
    i_name    text,
    i_type    mail.labels_types,
    i_color   text,
    i_request_info code.request_info DEFAULT NULL
) RETURNS mail.labels AS $$
DECLARE
    current_revision bigint;
    new_lid          integer;
    new_label        mail.labels%ROWTYPE;
BEGIN
    SELECT next_revision,
           next_lid
      INTO current_revision,
           new_lid
      FROM impl.acquire_current_serials(i_uid);

    INSERT INTO mail.labels
         (uid, lid, revision,
         name, type,
         color, created)
    VALUES (i_uid, new_lid, current_revision,
            i_name, i_type,
            i_color, current_timestamp)
    RETURNING *
    INTO new_label;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'label-create',
        i_changed      => jsonb_build_array(to_jsonb(
                            (new_label.lid,
                            new_label.name,
                            new_label.type)::impl.changed_label))
    );

    UPDATE mail.serials
       SET next_revision = next_revision + 1,
           next_lid = next_lid + 1
     WHERE uid = i_uid;

    RETURN new_label;
END;
$$ LANGUAGE plpgsql;
