CREATE OR REPLACE FUNCTION code.get_folder_path(
    i_uid bigint,
    i_fid bigint
) RETURNS text[] AS $$
WITH RECURSIVE folder_chain AS (
    SELECT ARRAY[f.name] as path,
           f.parent_fid as chain_parent_fid
      FROM mail.folders f
     WHERE f.uid = i_uid AND f.fid = i_fid
     UNION ALL
    SELECT array_prepend(fp.name, f.path) as path,
           fp.parent_fid as chain_parent_fid
      FROM folder_chain f
      JOIN mail.folders fp
        ON fp.uid = i_uid AND fp.fid = f.chain_parent_fid)
SELECT path AS folder_path
  FROM folder_chain
 WHERE chain_parent_fid is NULL
$$ LANGUAGE SQL;
