CREATE OR REPLACE FUNCTION code.get_folders_tree(
    i_uid      code.uid,
    i_root_fid code.fid
) RETURNS TABLE (
    fid        int,
    parent_fid int,
    name       text,
    path       text[],
    level      int
) AS $$
WITH RECURSIVE folder_chain AS (
    SELECT fid,
           parent_fid,
           name,
           ARRAY[f.name] as path,
           1 AS level
      FROM mail.folders f
     WHERE f.uid = i_uid
       AND f.fid = i_root_fid
     UNION ALL
    SELECT fp.fid,
           fp.parent_fid,
           fp.name,
           array_prepend(fp.name, f.path) as path,
           f.level + 1
      FROM folder_chain f
      JOIN mail.folders fp
        ON fp.uid = i_uid
       AND fp.parent_fid = f.fid)
SELECT * FROM folder_chain;
$$ LANGUAGE SQL STABLE;
