CREATE OR REPLACE FUNCTION code.add_folder_to_shared_folders(
    i_uid          bigint,
    i_fid          integer,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    v_current_revision  bigint := code.acquire_current_revision(i_uid);
BEGIN
    INSERT INTO mail.shared_folders
        (uid, fid, revision)
    VALUES
        (i_uid, i_fid, v_current_revision);

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => v_current_revision,
        i_type         => 'shared-folder-create',
        i_changed      => jsonb_build_array(jsonb_build_object('fid', i_fid))
    );

    RETURN code.increment_revision(i_uid);
END;
$$ LANGUAGE plpgsql;
