CREATE OR REPLACE FUNCTION code.add_folder_to_subscribed_folders(
    i_uid          code.uid,
    i_fid          code.fid,
    i_owner_uid    code.uid,
    i_owner_fid    code.fid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS mail.subscribed_folders AS $$
DECLARE
    v_serials_row      mail.serials;
    v_subscribed_row   mail.subscribed_folders%ROWTYPE;
BEGIN
    v_serials_row := impl.acquire_current_serials(i_uid);

    SELECT *
      INTO v_subscribed_row
      FROM mail.subscribed_folders
     WHERE uid = i_uid
       AND fid = i_fid
       AND owner_uid = i_owner_uid
       AND owner_fid = i_owner_fid;

    IF NOT found THEN
        INSERT INTO mail.subscribed_folders
            (uid, fid, revision,
             owner_uid, owner_fid,
             subscription_id,
             synced_revision)
        VALUES
            (i_uid, i_fid, v_serials_row.next_revision,
             i_owner_uid, i_owner_fid,
             v_serials_row.next_subscriber_subscription_id,
             0) -- cause not synced
        RETURNING * INTO v_subscribed_row;

        UPDATE mail.folders
           SET subscribed_for_shared_folder = true
         WHERE uid = i_uid
           AND fid = i_fid;

        UPDATE mail.serials
           SET next_subscriber_subscription_id = next_subscriber_subscription_id + 1,
               next_revision = next_revision + 1
         WHERE uid = i_uid;

        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => v_serials_row.next_revision,
            i_type         => 'subscribed-folder-create',
            i_changed      => jsonb_build_array(
                jsonb_build_object(
                    'fid', i_fid,
                    'owner_uid', i_owner_uid,
                    'owner_fid', i_owner_fid,
                    'subscription_id', v_serials_row.next_subscriber_subscription_id))
        );

    END IF;

    RETURN v_subscribed_row;
END;
$$ LANGUAGE plpgsql;
