CREATE OR REPLACE FUNCTION code.add_subscriber_to_shared_folders(
    i_uid          code.uid,
    i_fid          code.fid,
    i_subscriber   code.uid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    v_serials_row      mail.serials;
    v_current_revision bigint;
BEGIN
    v_serials_row := impl.acquire_current_serials(i_uid);
    v_current_revision := v_serials_row.next_revision;

    INSERT INTO mail.shared_folder_subscriptions
        (subscription_id, uid, fid, subscriber_uid)
    VALUES
        (v_serials_row.next_owner_subscription_id, i_uid, i_fid, i_subscriber)
    ON CONFLICT (uid, fid, subscriber_uid) DO NOTHING;

    IF found THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => v_current_revision,
            i_type         => 'shared-folder-subscribe',
            i_changed      => jsonb_build_array(
                jsonb_build_object(
                    'fid', i_fid,
                    'subscriber', i_subscriber,
                    'subscription_id', v_serials_row.next_owner_subscription_id))
        );
        UPDATE mail.serials
           SET next_revision = next_revision + 1,
               next_owner_subscription_id = next_owner_subscription_id + 1
         WHERE uid = i_uid;

        RETURN v_current_revision;
    END IF;

    RETURN code.unchanged_revision();
END;
$$ LANGUAGE plpgsql;