CREATE OR REPLACE FUNCTION code.add_to_storage_delete_queue(
    i_uid   bigint,
    i_st_id text[]
) RETURNS void AS $$
INSERT INTO mail.storage_delete_queue
    (uid, st_id)
SELECT i_uid, a_st_id
  FROM unnest(i_st_id) AS a_st_id
 WHERE NOT EXISTS (
    SELECT 1
      FROM mail.messages AS m
     WHERE hashtext(m.st_id) = hashtext(a_st_id)
       AND m.st_id = a_st_id
     UNION ALL
     SELECT 1
      FROM mail.windat_messages AS wm
     WHERE hashtext(wm.st_id) = hashtext(a_st_id)
       AND wm.st_id = a_st_id
     UNION ALL
     SELECT 1
       FROM backup.box as bb
      WHERE hashtext(bb.st_id) = hashtext(a_st_id)
        AND bb.st_id = a_st_id
);
$$ LANGUAGE SQL;

CREATE OR REPLACE FUNCTION code.add_to_storage_delete_queue(
    i_uid   bigint,
    i_st_id text
) RETURNS void AS $$
SELECT code.add_to_storage_delete_queue(i_uid, ARRAY[i_st_id]::text[]);
$$ LANGUAGE SQL;
