CREATE OR REPLACE FUNCTION code.add_unsubscribe_task(
    i_task_request_id       text,
    i_owner_uid             code.uid,
    i_owner_fids            code.fids,
    i_subscriber_uid        code.uid,
    i_root_subscriber_fid   code.fid
) RETURNS mail.unsubscribe_tasks AS $$
DECLARE
    v_owner_fids_sorted     code.fids := uniq(sort(i_owner_fids));
    v_unsubscribe_task      mail.unsubscribe_tasks;
BEGIN
    INSERT INTO mail.unsubscribe_tasks (
        task_request_id,
        owner_uid,
        owner_fids,
        subscriber_uid,
        root_subscriber_fid)
    VALUES (
        i_task_request_id,
        i_owner_uid,
        v_owner_fids_sorted,
        i_subscriber_uid,
        i_root_subscriber_fid)
    ON CONFLICT ON CONSTRAINT uk_unsubscribe_tasks_owner_subscriber_fids DO NOTHING
    RETURNING *
    INTO v_unsubscribe_task;

    IF NOT found THEN
        SELECT *
        INTO v_unsubscribe_task
        FROM mail.unsubscribe_tasks
        WHERE owner_uid = i_owner_uid
          AND owner_fids = v_owner_fids_sorted
          AND subscriber_uid = i_subscriber_uid
          AND root_subscriber_fid = i_root_subscriber_fid;
    END IF;

    RETURN v_unsubscribe_task;
END;
$$ LANGUAGE plpgsql;
