CREATE OR REPLACE FUNCTION code.create_folder(
    i_uid        code.uid,
    i_name       text,
    i_parent_fid integer, -- don't use domain for parent_fid, cause it can be NULL
    i_type       mail.folder_types,
    i_request_info code.request_info DEFAULT NULL
) RETURNS mail.folders AS $$
DECLARE
    current_revision bigint;
    new_fid          integer;
    new_folder       mail.folders%ROWTYPE;
BEGIN
    SELECT next_revision,
           next_fid
      INTO current_revision,
           new_fid
      FROM impl.acquire_current_serials(i_uid);

    INSERT INTO mail.folders
        (uid, fid, name,
        type, unique_type,
        parent_fid, revision,
        uidvalidity)
    VALUES
        (i_uid, new_fid, i_name,
        i_type, code.is_unique_folder_type(i_type),
        i_parent_fid, current_revision,
        code.folder_uidvalidity(current_timestamp))
    RETURNING *
    INTO new_folder;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'folder-create',
        i_changed      => jsonb_build_array(
                              to_jsonb(
                                  (new_folder.fid,
                                  new_folder.name,
                                  new_folder.type,
                                  new_folder.parent_fid)::impl.changed_folder))
    );

    UPDATE mail.serials
       SET next_revision = next_revision + 1,
           next_fid = next_fid + 1
     WHERE uid = i_uid;

    RETURN new_folder;
END;
$$ LANGUAGE plpgsql;
