CREATE OR REPLACE FUNCTION code.delete_folder(
    i_uid  code.uid,
    i_fid  code.fid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    IF EXISTS (
        SELECT 1
          FROM code.default_folders() df, mail.folders f
         WHERE f.fid = i_fid
           AND f.uid = i_uid
           AND f.type = df.type
    ) THEN
        RAISE EXCEPTION 'Can''t remove folder % for uid %, it is default', i_fid, i_uid;
    END IF;

    DELETE FROM mail.folders
     WHERE uid = i_uid
       AND fid = i_fid;

    IF found THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => current_revision,
            i_type         => 'folder-delete',
            i_changed      => jsonb_build_array(jsonb_build_object(
                                'fid', i_fid))
        );
        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
