CREATE OR REPLACE FUNCTION code.delete_folder_from_subscribed_folders(
    i_uid          code.uid,
    i_owner_uid    code.uid,
    i_owner_fids   code.fids,
    i_request_info code.request_info DEFAULT NULL
) RETURNS SETOF mail.subscribed_folders AS $$
DECLARE
    v_subscribed_rows mail.subscribed_folders[];
    v_revision        bigint;
BEGIN
    v_revision := code.acquire_current_revision(i_uid);

    SELECT array_agg(sf)
      INTO v_subscribed_rows
      FROM mail.subscribed_folders sf
     WHERE uid = i_uid
       AND owner_uid = i_owner_uid
       AND sf.owner_fid = ANY(i_owner_fids);

    IF found THEN

      DELETE FROM mail.subscribed_folders
      WHERE uid = i_uid
        AND subscribed_folders.fid IN (SELECT r.fid FROM unnest(v_subscribed_rows) r);

     UPDATE mail.folders
        SET subscribed_for_shared_folder = NULL,
            revision = v_revision
      WHERE uid = i_uid
        AND folders.fid IN (SELECT r.fid FROM unnest(v_subscribed_rows) r);

        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => v_revision,
            i_type         => 'subscribed-folder-delete',
            i_changed      => jsonb_build_array(ARRAY(
              SELECT
              jsonb_build_array(
                jsonb_build_object(
                    'fid', fid,
                    'owner_uid', owner_uid,
                    'owner_fid', sf.owner_fid,
                    'subscription_id', subscription_id
                )
              )
                FROM unnest(v_subscribed_rows) sf))
        );

          PERFORM code.increment_revision(i_uid);
    END IF;
    RETURN QUERY (SELECT * FROM unnest(v_subscribed_rows));
END;
$$ LANGUAGE plpgsql;