CREATE OR REPLACE FUNCTION code.delete_label(
    i_uid code.uid,
    i_lid code.lid,
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
    i_mids_with_lid bigint[] := impl.find_mids_by_lid(i_uid, i_lid);
BEGIN
    IF EXISTS (
        SELECT 1
          FROM mail.labels l
          JOIN code.default_labels() dl
         USING (name, type)
         WHERE l.lid = i_lid
           AND l.uid = i_uid
    ) THEN
        RAISE EXCEPTION 'Can''t remove label % for uid %, it is default', i_lid, i_uid;
    END IF;

    IF cardinality(i_mids_with_lid) > 0 THEN
        IF EXISTS (
            SELECT 1
              FROM mail.box
             WHERE uid = i_uid
               AND mid = ANY(i_mids_with_lid)
               AND tid IS NOT NULL
        ) THEN
            RAISE EXCEPTION 'Can''t remove label % for uid %, marked messages exist', i_lid, i_uid;
        END IF;

        -- remove i_lid
        UPDATE mail.box
           SET lids = uniq(sort(lids - ARRAY[i_lid::int]))
         WHERE uid = i_uid
           AND mid = ANY(i_mids_with_lid)
           AND tid IS NULL;
    END IF;

    DELETE FROM mail.labels
     WHERE uid = i_uid
       AND lid = i_lid;

    IF found THEN
        PERFORM impl.log_change(
            i_uid          => i_uid,
            i_request_info => i_request_info,
            i_revision     => current_revision,
            i_type         => 'label-delete',
            i_changed      => jsonb_build_array(jsonb_build_object('lid', i_lid))
        );
        RETURN code.increment_revision(i_uid);
    ELSE
        RETURN code.unchanged_revision();
    END IF;
END;
$$ LANGUAGE plpgsql;
