CREATE OR REPLACE FUNCTION code.delete_shared_folder_subscriptions(
    i_uid               code.uid,
    i_subscription_ids  code.subscription_ids,
    i_request_info      code.request_info DEFAULT NULL
) RETURNS SETOF mail.shared_folder_subscriptions AS $$
DECLARE
    v_subscriptions     mail.shared_folder_subscriptions[];
    v_revision          bigint;
BEGIN
    v_revision := code.acquire_current_revision(i_uid);

    SELECT array_agg(s)
      INTO v_subscriptions
      FROM mail.shared_folder_subscriptions s
     WHERE uid = i_uid
       AND subscription_id = ANY(i_subscription_ids);

    IF cardinality(v_subscriptions) > 0 THEN

        DELETE FROM mail.shared_folder_subscriptions
        WHERE uid = i_uid
          AND subscription_id IN (SELECT r.subscription_id FROM unnest(v_subscriptions) r);

        PERFORM impl.log_change(
          i_uid          => i_uid,
          i_request_info => i_request_info,
          i_revision     => v_revision,
          i_type         => 'shared-folder-unsubscribe',
          i_changed      => jsonb_build_array(ARRAY(
            SELECT
            jsonb_build_array(
              jsonb_build_object(
                  'uid', uid,
                  'fid', fid,
                  'subscriber_uid', subscriber_uid,
                  'subscription_id', subscription_id
              )
            )
            FROM unnest(v_subscriptions) ))
        );

        PERFORM code.increment_revision(i_uid);
    END IF;
    RETURN QUERY (SELECT * FROM unnest(v_subscriptions));
END;
$$ LANGUAGE plpgsql;
