CREATE OR REPLACE FUNCTION code.force_delete_messages(
    i_uid  code.uid,
    i_mids code.mids,
    i_request_info code.request_info DEFAULT NULL
) RETURNS code.operation_result AS $$
DECLARE
    current_revision constant bigint := code.acquire_current_revision(i_uid);
    deleted_messages impl.moved_message[];
BEGIN
    SELECT *
      INTO deleted_messages
      FROM impl.delete_messages_impl(i_uid, i_mids, current_revision);

    IF deleted_messages IS NULL OR cardinality(deleted_messages) = 0 THEN
        RETURN code.unchanged_result();
    END IF;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'delete',
        i_changed      => ARRAY(
            SELECT (mid, src_fid)::impl.deleted_message
              FROM unnest(deleted_messages))::impl.changed_with_fids
    );

    PERFORM code.increment_revision(i_uid);

    RETURN (current_revision, ARRAY(SELECT mid FROM unnest(deleted_messages)));
END;
$$ LANGUAGE plpgsql;
