CREATE OR REPLACE FUNCTION code.get_or_create_tab(
    i_uid        code.uid,
    i_tab        mail.tab_types,
    i_request_info code.request_info DEFAULT NULL
) RETURNS mail.tabs AS $$
DECLARE
    current_revision    bigint;
    new_tab             mail.tabs;
BEGIN
    SELECT *
      INTO new_tab
      FROM mail.tabs
     WHERE uid = i_uid
       AND tab = i_tab;

    IF found THEN
        RETURN new_tab;
    END IF;

    current_revision := code.acquire_current_revision(i_uid);

    SELECT *
      INTO new_tab
      FROM mail.tabs
     WHERE uid = i_uid
       AND tab = i_tab;

    IF found THEN
        RETURN new_tab;
    END IF;

    INSERT INTO mail.tabs
        (uid, tab, revision)
    VALUES
        (i_uid, i_tab, current_revision)
    RETURNING *
    INTO new_tab;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'tab-create',
        i_changed      => jsonb_build_array(jsonb_build_object(
                                'tab', new_tab.tab))
    );

    PERFORM code.increment_revision(i_uid);

    RETURN new_tab;
END;
$$ LANGUAGE plpgsql;
