CREATE OR REPLACE FUNCTION code.get_unsubscribe_tasks(
    i_task_limit    code.subscriptions_limit,
    i_task_ttl      interval
) RETURNS SETOF mail.unsubscribe_tasks AS $$

UPDATE mail.unsubscribe_tasks
SET assigned = current_timestamp
WHERE task_id IN (
    SELECT t.task_id
    FROM mail.unsubscribe_tasks t
    WHERE (t.assigned IS NULL OR (t.assigned + i_task_ttl) < current_timestamp)
        AND NOT EXISTS (
            SELECT 1
            FROM mail.shared_folder_subscriptions s
            WHERE s.uid = t.owner_uid
                AND s.subscriber_uid = t.subscriber_uid
                AND s.fid in (select * from unnest(t.owner_fids))
                AND state != 'terminated'
        )
    ORDER BY t.assigned ASC NULLS FIRST
    LIMIT i_task_limit
    FOR UPDATE
    SKIP LOCKED
)
RETURNING *;

$$ LANGUAGE SQL;
