CREATE OR REPLACE FUNCTION code.imap_add_unsubscribed(
    i_uid          code.uid,
    i_full_name    text[],
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    IF NOT EXISTS (
        SELECT 1
          FROM mail.imap_unsubscribed_folders
         WHERE uid = i_uid
           AND full_name = i_full_name
    ) THEN
        INSERT INTO mail.imap_unsubscribed_folders
            (uid, full_name, revision)
        VALUES
            (i_uid, i_full_name, current_revision);

        PERFORM impl.log_change(
            i_uid,
            i_request_info,
            current_revision,
            'imap-add-unsubscribed',
            json_build_array(
                json_build_object(
                    'full_name', i_full_name
            ))::jsonb,
            json_build_object(
                'full_name', i_full_name
            )::jsonb);
    END IF;
    RETURN code.unchanged_revision();
END;
$$ LANGUAGE plpgsql;
