CREATE OR REPLACE FUNCTION code.imap_delete_unsubscribed(
    i_uid          code.uid,
    i_full_name    text[],
    i_request_info code.request_info DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    current_revision bigint := code.acquire_current_revision(i_uid);
BEGIN
    DELETE FROM mail.imap_unsubscribed_folders
     WHERE uid = i_uid
       AND full_name = i_full_name;
    IF found THEN
        PERFORM impl.log_change(
            i_uid,
            i_request_info,
            current_revision,
            'imap-delete-unsubscribed',
            json_build_array(
                json_build_object(
                    'full_name', i_full_name
            ))::jsonb,
            json_build_object(
                'full_name', i_full_name
            )::jsonb);
        RETURN code.increment_revision(i_uid);
    END IF;
    RETURN code.unchanged_revision();
END;
$$ LANGUAGE plpgsql;
