CREATE OR REPLACE FUNCTION code.init_user_data(
    i_uid code.uid,
    i_init_revision bigint
) RETURNS void AS $$
DECLARE
    v_serials         mail.serials;
    folders_created   integer;
    labels_created    integer;
BEGIN
    v_serials := impl.acquire_current_serials(i_uid);

    INSERT INTO mail.folders
        (uid, fid,
        name, type,
        unique_type,
        revision,
        uidvalidity)
    SELECT
        i_uid, (v_serials.next_fid - 1) + row_number() over (order by type) as fid,
        df.name, df.type,
        code.is_unique_folder_type(df.type),
        i_init_revision,
        code.folder_uidvalidity(current_timestamp)
      FROM code.default_folders() df;

    GET DIAGNOSTICS folders_created = ROW_COUNT;

    INSERT INTO mail.imap_unsubscribed_folders
        (uid, full_name, revision)
    SELECT
        i_uid, ARRAY[name], i_init_revision
      FROM code.default_folders()
     WHERE imap_unsubscribed;

    INSERT INTO mail.labels
        (uid, lid,
        revision, name, type)
    SELECT
        i_uid, (v_serials.next_lid - 1) + row_number() over (order by name, type) as lid,
        i_init_revision,
        name, type
      FROM code.default_labels();

    GET DIAGNOSTICS labels_created = ROW_COUNT;

    INSERT INTO mail.counters
        (uid, fresh_count, revision,
         has_attaches_count,
         has_attaches_seen)
    VALUES
        (i_uid, 0, i_init_revision, 0, 0)
    ON CONFLICT (uid) DO UPDATE
        SET fresh_count = 0,
            revision = i_init_revision,
            has_attaches_count = 0,
            has_attaches_seen = 0;

    INSERT INTO mail.tabs
        (uid, tab, revision)
    SELECT
        i_uid, tab, i_init_revision
      FROM code.default_tabs();

    UPDATE mail.serials
       SET next_fid = next_fid + folders_created,
           next_lid = next_lid + labels_created
     WHERE uid = i_uid;

END;
$$ LANGUAGE plpgsql;
