CREATE OR REPLACE FUNCTION code.join_threads(
    i_uid     code.uid,
    i_tid     code.tid,
    join_tids code.tids,
    i_request_info code.request_info DEFAULT NULL
) RETURNS code.operation_result AS $$
DECLARE
    current_revision bigint;
    joined           impl.short_changed_message[];
BEGIN
    current_revision := code.acquire_current_revision(i_uid);

    joined := impl.join_threads(i_uid, i_tid, join_tids, current_revision);

    IF coalesce(cardinality(joined), 0) = 0 THEN
        RETURN code.unchanged_result();
    END IF;

    PERFORM code.increment_revision(i_uid);

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'threads-join',
        i_changed      => joined::impl.changed_with_fids,
        i_args         => jsonb_build_object('tid', i_tid, 'join_tids', join_tids)
    );

    RETURN (current_revision, ARRAY(SELECT mid FROM unnest(joined)))::code.operation_result;
END;
$$ LANGUAGE plpgsql;
