CREATE OR REPLACE FUNCTION code.move_messages(
    i_uid   code.uid,
    i_mids  code.mids,
    i_dst_fid code.fid,
    i_dst_tab mail.tab_types,
    i_request_info code.request_info DEFAULT NULL
) RETURNS code.operation_result AS $$
DECLARE
    current_revision     constant bigint := code.acquire_current_revision(i_uid);
    moved                impl.moved_message[];
BEGIN
    SELECT *
      INTO moved
      FROM impl.move_messages_impl(i_uid, i_mids, i_dst_fid, i_dst_tab, current_revision);

    IF moved IS NULL OR cardinality(moved) = 0 THEN
        RETURN code.unchanged_result();
    END IF;

    PERFORM impl.log_change(
        i_uid          => i_uid,
        i_request_info => i_request_info,
        i_revision     => current_revision,
        i_type         => 'move',
        i_changed      => ARRAY(
          SELECT (mid, dst_tid, i_dst_fid, src_fid,
                  seen, true, deleted,
                  CASE WHEN dst_tid IS NULL
                       THEN ARRAY[]::integer[]
                       ELSE lids END,
                  i_dst_tab, src_tab
                 )::impl.changed_message_with_src_fid_tab
           FROM unnest(moved))::impl.changed_with_fids,
        i_args => jsonb_build_object('fid', i_dst_fid, 'tab', i_dst_tab)
    );

    PERFORM code.increment_revision(i_uid);

    RETURN (current_revision, ARRAY(SELECT mid FROM unnest(moved)))::code.operation_result;
END;
$$ LANGUAGE plpgsql;
