CREATE OR REPLACE FUNCTION code.purge_box(
    i_uid code.uid
) RETURNS bool AS $$
DECLARE
    v_mids bigint[];
BEGIN
    v_mids := ARRAY(
        SELECT mid
          FROM mail.box
         WHERE uid = i_uid
         LIMIT impl.purge_mids_chunk_size());

    DELETE FROM mail.pop3_box
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    DELETE FROM mail.box
     WHERE uid = i_uid
       AND mid = ANY(v_mids);

    RETURN cardinality(v_mids) < impl.purge_mids_chunk_size();
END;
$$ LANGUAGE plpgsql;