CREATE OR REPLACE FUNCTION code.purge_deleted_messages(
    i_uid  code.uid,
    i_mids code.mids
) RETURNS SETOF code.purged_message AS $$
DECLARE
    deleted_messages impl.purged_message_with_st_id[];
    v_witdat_stids   text[];
BEGIN
    WITH windat_attaches_purged AS (
      DELETE FROM mail.windat_messages
       WHERE uid = i_uid
         AND mid = ANY(i_mids)
     RETURNING st_id
    )
    SELECT array_agg(st_id)
      INTO v_witdat_stids
      FROM windat_attaches_purged;

    PERFORM code.add_to_storage_delete_queue(i_uid, v_witdat_stids);

    WITH messages_purged AS (
        DELETE FROM mail.messages
         WHERE uid = i_uid
           AND mid = ANY(i_mids)
     RETURNING mid, st_id, recipients, size, attributes
    ), deleted_box_purged AS (
        DELETE FROM mail.deleted_box
         WHERE uid = i_uid
           AND mid = ANY(i_mids)
     RETURNING mid, info
    )
    SELECT array_agg((m.mid, m.recipients, m.size, db.info, m.st_id, m.attributes)::impl.purged_message_with_st_id)
      INTO deleted_messages
      FROM messages_purged m
      JOIN deleted_box_purged db
     USING (mid);

    PERFORM (
        SELECT code.add_to_storage_delete_queue(i_uid, array_agg(st_id)::text[])
          FROM unnest(deleted_messages) as st_id
         WHERE NOT impl.is_shared_message(attributes)
    );

    RETURN QUERY
        SELECT mid::code.mid, to_json(recipients)::jsonb as recipients, size, deleted_info
          FROM unnest(deleted_messages);
END;
$$ LANGUAGE plpgsql;
